/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.util;

import de.sogomn.engine.util.FileUtils;
import de.sogomn.rat.service.IOperatingSystemService;
import de.sogomn.rat.util.NimbusGuiSettings;
import de.sogomn.rat.util.XorCipher;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

public final class Constants {
    private static final String DATA_PATH = "/data";
    public static final String VERSION = "1.29.3.1";
    public static final ResourceBundle LANGUAGE = ResourceBundle.getBundle("language.lang");
    public static final IOperatingSystemService OS_SERVICE = IOperatingSystemService.getInstance();
    public static final String[] ADDRESSES;
    public static final int[] PORTS;
    public static final Path JAR_FILE;

    static {
        byte[] data = FileUtils.readInternalData(DATA_PATH);
        data = Base64.getDecoder().decode(data);
        data = XorCipher.crypt(data);
        String text = new String(data);
        String[] lines = text.split("\r\n");
        ADDRESSES = new String[lines.length];
        PORTS = new int[lines.length];
        int i = 0;
        while (i < lines.length) {
            try {
                String line = lines[i];
                String[] connectionData = line.split(":");
                String address = connectionData[0];
                int port = Integer.parseInt(connectionData[1]);
                Constants.ADDRESSES[i] = address;
                Constants.PORTS[i] = port;
            }
            catch (Exception ex) {
                Constants.ADDRESSES[i] = "";
                Constants.PORTS[i] = 0;
            }
            ++i;
        }
        Path jarFile = null;
        try {
            jarFile = Paths.get(Constants.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        JAR_FILE = jarFile;
    }

    private Constants() {
    }

    public static void setSystemLookAndFeel() {
        try {
            String className = UIManager.getSystemLookAndFeelClassName();
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            UIManager.setLookAndFeel(className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setNimbusLookAndFeel() {
        NimbusLookAndFeel nimbus = new NimbusLookAndFeel();
        UIDefaults defaults = nimbus.getDefaults();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        NimbusGuiSettings.setDefaults(defaults);
        try {
            UIManager.setLookAndFeel(nimbus);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

