/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.engine.fx.Sound;
import de.sogomn.engine.util.FileUtils;
import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.IPacket;

public final class AudioPacket
implements IPacket {
    private byte[] data;

    public AudioPacket(byte[] data) {
        this.data = data;
    }

    public AudioPacket(String path) {
        this.data = FileUtils.readExternalData(path);
    }

    public AudioPacket() {
        this.data = new byte[0];
    }

    @Override
    public void send(ActiveConnection connection) {
        connection.writeInt(this.data.length);
        connection.write(this.data);
    }

    @Override
    public void receive(ActiveConnection connection) {
        int length = connection.readInt();
        this.data = new byte[length];
        connection.read(this.data);
    }

    @Override
    public void execute(ActiveConnection connection) {
        Sound sound = Sound.loadSound(this.data);
        sound.play();
    }

    public byte[] getData() {
        return this.data;
    }
}

