/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.gui.swing;

import de.sogomn.rat.gui.IChatGui;
import de.sogomn.rat.gui.swing.AbstractSwingGui;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class ChatSwingGui
extends AbstractSwingGui
implements IChatGui {
    private JTextArea chat = new JTextArea();
    private JTextField submit = new JTextField();
    private JScrollPane scrollPane = new JScrollPane(this.chat, 22, 31);
    private String message;
    private static final Dimension SIZE = new Dimension(500, 500);
    private static final String USER_PREFIX = "You: ";

    public ChatSwingGui() {
        Container contentPane = this.frame.getContentPane();
        this.submit.addActionListener(this::messageSubmitted);
        this.chat.setEditable(false);
        this.chat.setLineWrap(true);
        this.chat.setWrapStyleWord(true);
        contentPane.add((Component)this.scrollPane, "Center");
        contentPane.add((Component)this.submit, "South");
        this.frame.setDefaultCloseOperation(1);
        this.frame.setPreferredSize(SIZE);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
    }

    private void messageSubmitted(ActionEvent a) {
        String message = this.submit.getText();
        if (!message.isEmpty()) {
            this.message = message;
            this.notifyListeners(controller -> controller.userInput("Message sent", this));
            this.appendLine(USER_PREFIX + message);
        }
        this.submit.setText("");
    }

    @Override
    public void appendLine(String line) {
        line = String.valueOf(line) + System.lineSeparator();
        this.chat.append(line);
        JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
        int bottom = scrollBar.getMaximum();
        scrollBar.setValue(bottom);
    }

    @Override
    public String getMessageInput() {
        return this.message;
    }
}

