/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.gui.swing;

import de.sogomn.engine.util.AbstractListenerContainer;
import de.sogomn.rat.gui.IGui;
import de.sogomn.rat.gui.IGuiController;
import java.awt.Image;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class AbstractSwingGui
extends AbstractListenerContainer<IGuiController>
implements IGui {
    protected JFrame frame = new JFrame();
    protected JFileChooser fileChooser = new JFileChooser(".");

    private int showOptionDialog(int messageType, String message, int optionType, String ... options) {
        int input = JOptionPane.showOptionDialog(this.frame, message, null, optionType, messageType, null, options, null);
        return input;
    }

    private void showMessageDialog(int messageType, String message) {
        JOptionPane.showMessageDialog(this.frame, message, null, messageType, null);
    }

    @Override
    public void update() {
    }

    @Override
    public void close() {
        SwingUtilities.invokeLater(() -> {
            this.frame.setVisible(false);
            this.frame.dispose();
        });
    }

    @Override
    public void setVisible(boolean visible) {
        SwingUtilities.invokeLater(() -> this.frame.setVisible(visible));
    }

    @Override
    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    @Override
    public void setIcons(List<? extends Image> icons) {
        this.frame.setIconImages(icons);
    }

    @Override
    public void showWarning(String message) {
        if (!this.isVisible()) {
            return;
        }
        this.showMessageDialog(2, message);
    }

    @Override
    public int showWarning(String message, String yes, String no) {
        if (!this.isVisible()) {
            return -1;
        }
        return this.showOptionDialog(2, message, 0, yes, no);
    }

    @Override
    public void showError(String message) {
        if (!this.isVisible()) {
            return;
        }
        this.showMessageDialog(0, message);
    }

    @Override
    public void showMessage(String message) {
        if (!this.isVisible()) {
            return;
        }
        this.showMessageDialog(1, message);
    }

    @Override
    public int showOptions(String message, String yes, String no, String cancel) {
        if (!this.isVisible()) {
            return -1;
        }
        return this.showOptionDialog(3, message, 1, yes, no, cancel);
    }

    @Override
    public String getInput(String message) {
        if (!this.isVisible()) {
            return null;
        }
        String input = JOptionPane.showInputDialog(this.frame, (Object)message);
        return input;
    }

    @Override
    public boolean isVisible() {
        return this.frame.isVisible();
    }

    @Override
    public File getOpenFile(String type) {
        FileNameExtensionFilter filter = type != null ? new FileNameExtensionFilter("*." + type, type) : null;
        this.fileChooser.setFileFilter(filter);
        int input = this.fileChooser.showOpenDialog(this.frame);
        if (input == 0) {
            File file = this.fileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    @Override
    public File getSaveFile() {
        int input = this.fileChooser.showSaveDialog(this.frame);
        if (input == 0) {
            File file = this.fileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    @Override
    public File getSaveFile(String type) {
        String suffix;
        File file = this.getSaveFile();
        if (file == null) {
            return null;
        }
        String path = file.toString().toLowerCase();
        if (!path.endsWith(suffix = "." + type.toLowerCase())) {
            file = new File(file + suffix);
        }
        return file;
    }
}

