/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.util;

import de.sogomn.engine.IUpdatable;
import java.util.ArrayList;

public final class Scheduler
implements IUpdatable {
    private ArrayList<Task> tasks = new ArrayList();

    @Override
    public void update(double delta) {
        int size = this.tasks.size();
        int i = 0;
        while (i < size) {
            Task task = this.tasks.get(i);
            task.update(delta);
            if (task.isDone()) {
                task.execute();
            }
            ++i;
        }
        this.tasks.removeIf(Task::isDone);
    }

    public void clearTasks() {
        this.tasks.clear();
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public void removeTask(Task task) {
        this.tasks.remove(task);
    }

    public boolean hasTask() {
        return !this.tasks.isEmpty();
    }

    public static final class Task
    implements IUpdatable {
        private Runnable runnable;
        private double timer;
        private float time;

        public Task(Runnable runnable, float time) {
            this.runnable = runnable;
            this.time = time;
        }

        @Override
        public void update(double delta) {
            this.timer += delta;
        }

        public void reset() {
            this.timer = 0.0;
        }

        public float getTime() {
            return this.time;
        }

        public boolean isDone() {
            return this.timer >= (double)this.time;
        }

        public void execute() {
            this.runnable.run();
        }
    }
}

