/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.noise;

import de.sogomn.engine.noise.INoise2D;
import de.sogomn.engine.util.Vector2D;
import java.util.Random;

public final class PerlinNoise
implements INoise2D {
    private int gridWidth;
    private int gridHeight;
    private Vector2D[][] grid;
    private double contrast;
    private Random ran;
    private static final double VECTOR_LENGTH = 1.0;
    private static final double DEFAULT_CONTRAST = 1.0;

    public PerlinNoise(int gridWidth, int gridHeight) {
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.grid = new Vector2D[gridWidth][gridHeight];
        this.contrast = 1.0;
        this.ran = new Random();
        this.randomizeGrid();
    }

    public PerlinNoise(int gridWidth, int gridHeight, long seed) {
        this(gridWidth, gridHeight);
        this.ran.setSeed(seed);
    }

    private double interpolate(double one, double two, double weight) {
        double advancedWeight = (1.0 - Math.cos(weight * Math.PI)) / 2.0;
        double value = one * (1.0 - advancedWeight) + two * advancedWeight;
        return value;
    }

    @Override
    public double getValue(double x, double y) {
        int x0 = (int)x;
        int y0 = (int)y;
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        if (x0 < 0 || y0 < 0 || x1 > this.gridWidth - 1 || y1 > this.gridHeight - 1) {
            return 0.0;
        }
        Vector2D point = new Vector2D(x, y);
        Vector2D gridPoint00 = new Vector2D(x0, y0);
        Vector2D gridPoint10 = new Vector2D(x1, y0);
        Vector2D gridPoint01 = new Vector2D(x0, y1);
        Vector2D gridPoint11 = new Vector2D(x1, y1);
        Vector2D distance00 = point.distance(gridPoint00);
        Vector2D distance10 = point.distance(gridPoint10);
        Vector2D distance01 = point.distance(gridPoint01);
        Vector2D distance11 = point.distance(gridPoint11);
        Vector2D grid00 = this.grid[x0][y0];
        Vector2D grid10 = this.grid[x1][y0];
        Vector2D grid01 = this.grid[x0][y1];
        Vector2D grid11 = this.grid[x1][y1];
        double dot00 = distance00.dot(grid00);
        double dot10 = distance10.dot(grid10);
        double dot01 = distance01.dot(grid01);
        double dot11 = distance11.dot(grid11);
        double weightX = x - (double)x0;
        double weightY = y - (double)y0;
        double top = this.interpolate(dot00, dot10, weightX);
        double bottom = this.interpolate(dot01, dot11, weightX);
        double value = this.interpolate(top, bottom, weightY) * this.contrast;
        value = Math.max(Math.min(value, 1.0), -1.0);
        return value;
    }

    public void randomizeGrid() {
        int x = 0;
        while (x < this.gridWidth) {
            int y = 0;
            while (y < this.gridHeight) {
                Vector2D vector;
                double rotation = this.ran.nextDouble() * 360.0;
                this.grid[x][y] = vector = new Vector2D(1.0, 0.0).rotate(rotation);
                ++y;
            }
            ++x;
        }
    }

    public void rotateGrid(double degrees) {
        int x = 0;
        while (x < this.gridWidth) {
            int y = 0;
            while (y < this.gridHeight) {
                Vector2D vector;
                this.grid[x][y] = vector = this.grid[x][y].rotate(degrees);
                ++y;
            }
            ++x;
        }
    }

    public void setContrast(double contrast) {
        this.contrast = contrast;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }
}

