/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.net;

import de.sogomn.engine.net.IClosable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TCPServer
implements IClosable {
    private ServerSocket server;
    private boolean open;

    public TCPServer(int port) {
        try {
            this.server = new ServerSocket(port);
            this.open = true;
        }
        catch (IOException ex) {
            this.handleException(ex);
        }
    }

    protected void handleException(Exception ex) {
        if (ex instanceof NullPointerException) {
            System.err.println("Server has not been initialized successfully: " + ex.getMessage());
        } else if (ex instanceof IOException) {
            System.err.println("Server closed: " + ex.getMessage());
        } else {
            System.err.println("Server error: " + ex.getMessage());
        }
        this.close();
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Socket acceptConnection() {
        try {
            Socket socket = this.server.accept();
            return socket;
        }
        catch (IOException | NullPointerException ex) {
            this.handleException(ex);
            return null;
        }
    }

    public final int getPort() {
        return this.server.getLocalPort();
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }
}

