/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.net;

import de.sogomn.engine.net.IClosable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class TCPConnection
implements IClosable {
    private String address;
    private int port;
    private int localPort;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private boolean open;

    public TCPConnection(String address, int port) {
        this.address = address;
        this.port = port;
        try {
            this.socket = new Socket(address, port);
            this.localPort = this.socket.getLocalPort();
            this.initIO(this.socket);
        }
        catch (IOException ex) {
            this.handleException(ex);
        }
    }

    public TCPConnection(Socket socket) {
        this.socket = socket;
        this.address = socket.getInetAddress().getHostAddress();
        this.port = socket.getPort();
        this.localPort = socket.getLocalPort();
        try {
            this.initIO(socket);
        }
        catch (IOException ex) {
            this.handleException(ex);
        }
    }

    private void initIO(Socket socket) throws IOException {
        this.in = new DataInputStream(socket.getInputStream());
        this.out = new DataOutputStream(socket.getOutputStream());
        this.open = true;
    }

    protected void handleException(Exception ex) {
        if (ex instanceof NullPointerException) {
            System.err.println("Tried to close connection but it already is: " + ex.getMessage());
        } else if (ex instanceof IOException) {
            System.err.println("Connection closed: " + ex.getMessage());
        } else {
            System.err.println("Connection error: " + ex.getMessage());
        }
        this.close();
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] readAllAvailable() {
        try {
            int available = this.in.available();
            byte[] buffer = new byte[available];
            this.in.readFully(buffer);
            return buffer;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    public void write(byte[] data) {
        try {
            this.out.write(data);
            this.out.flush();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void writeInt(int i) {
        try {
            this.out.writeInt(i);
            this.out.flush();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void writeByte(byte b) {
        try {
            this.out.writeByte(b);
            this.out.flush();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void writeUtf(String message) {
        try {
            this.out.writeUTF(message);
            this.out.flush();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void writeLong(long l) {
        try {
            this.out.writeLong(l);
            this.out.flush();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void writeShort(short s) {
        try {
            this.out.writeShort(s);
            this.out.flush();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void read(byte[] buffer) {
        try {
            this.in.readFully(buffer);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public int readInt() {
        try {
            int i = this.in.readInt();
            return i;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return 0;
        }
    }

    public byte readByte() {
        try {
            byte b = this.in.readByte();
            return b;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return 0;
        }
    }

    public String readUtf() {
        try {
            String message = this.in.readUTF();
            return message;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    public long readLong() {
        try {
            long l = this.in.readLong();
            return l;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return 0L;
        }
    }

    public short readShort() {
        try {
            short s = this.in.readShort();
            return s;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return 0;
        }
    }

    public int available() {
        try {
            return this.in.available();
        }
        catch (Exception ex) {
            this.handleException(ex);
            return 0;
        }
    }

    public final String getAddress() {
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }
}

