/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.fx;

import de.sogomn.engine.IUpdatable;
import de.sogomn.engine.util.Scheduler;
import java.awt.Graphics2D;

public final class Camera
implements IUpdatable {
    private double x;
    private double y;
    private double targetX;
    private double targetY;
    private float smoothness;
    private double minX = -2.147483648E9;
    private double minY = -2.147483648E9;
    private double maxX = 2.147483647E9;
    private double maxY = 2.147483647E9;
    private double rotation;
    private double pivotX;
    private double pivotY;
    private double scale;
    private double centerX;
    private double centerY;
    private double xOffset;
    private double yOffset;
    private double rotationOffset;
    private Scheduler shakeScheduler = new Scheduler();
    private Shaker shaker = new Shaker();
    public static final float NO_SMOOTHNESS = 0.0f;
    public static final int NO_MINIMUM = Integer.MIN_VALUE;
    public static final int NO_MAXIMUM = Integer.MAX_VALUE;

    private void move(double delta) {
        if (this.smoothness == 0.0f) {
            this.x = this.targetX;
            this.y = this.targetY;
        } else {
            double distX = this.targetX - this.x;
            double distY = this.targetY - this.y;
            this.x += distX / (double)this.smoothness * delta;
            this.y += distY / (double)this.smoothness * delta;
        }
    }

    private void clampPosition() {
        this.x = Math.max(Math.min(this.x, this.maxX), this.minX);
        this.y = Math.max(Math.min(this.y, this.maxY), this.minY);
        double actualX = this.getX();
        double actualY = this.getY();
        if (actualX < this.minX) {
            this.xOffset = this.x - this.minX;
        } else if (actualX > this.maxX) {
            this.xOffset = this.x - this.maxX;
        }
        if (actualY < this.minY) {
            this.yOffset = this.y - this.minY;
        } else if (actualY > this.maxY) {
            this.yOffset = this.y - this.maxY;
        }
    }

    private void clampTarget() {
        this.targetX = Math.max(Math.min(this.targetX, this.maxX), this.minX);
        this.targetY = Math.max(Math.min(this.targetY, this.maxY), this.minY);
    }

    @Override
    public void update(double delta) {
        this.move(delta);
        this.shakeScheduler.update(delta);
        this.shaker.update(delta);
        this.clampPosition();
    }

    public void apply(Graphics2D g) {
        double actualX = this.getX();
        double actualY = this.getY();
        double actualRotation = this.getRotation();
        if (actualRotation != 0.0) {
            g.rotate(actualRotation, this.pivotX, this.pivotY);
        }
        g.translate(-actualX, -actualY);
        if (this.scale != 0.0) {
            g.translate(this.centerX, this.centerY);
            g.scale(this.scale, this.scale);
            g.translate(-this.centerX, -this.centerY);
        }
    }

    public void revert(Graphics2D g) {
        double actualX = this.getX();
        double actualY = this.getY();
        double actualRotation = this.getRotation();
        if (this.scale != 0.0) {
            double reverseScale = 1.0 / this.scale;
            g.translate(this.centerX, this.centerY);
            g.scale(reverseScale, reverseScale);
            g.translate(-this.centerX, -this.centerY);
        }
        g.translate(actualX, actualY);
        if (actualRotation != 0.0) {
            g.rotate(-actualRotation, this.pivotX, this.pivotY);
        }
    }

    public void reset() {
        this.y = 0.0;
        this.x = 0.0;
        this.targetY = 0.0;
        this.targetX = 0.0;
        this.resetShake();
        this.resetRotation();
        this.resetScaling();
    }

    public void resetShake() {
        this.yOffset = 0.0;
        this.xOffset = 0.0;
        this.rotationOffset = 0.0;
        this.shakeScheduler.clearTasks();
        this.shaker.stop();
    }

    public void resetRotation() {
        this.rotation = 0.0;
        this.pivotY = 0.0;
        this.pivotX = 0.0;
    }

    public void resetScaling() {
        this.scale = 0.0;
        this.centerY = 0.0;
        this.centerX = 0.0;
    }

    public void shake(double xIntensity, double yIntensity, double rotationIntensity, float duration) {
        Scheduler.Task task = new Scheduler.Task(() -> this.resetShake(), duration);
        this.resetShake();
        this.shakeScheduler.addTask(task);
        this.shaker.shake(xIntensity, yIntensity, Math.toRadians(rotationIntensity), duration);
    }

    public void moveBy(double x, double y) {
        this.targetX += x;
        this.targetY += y;
        this.clampTarget();
    }

    public void moveTo(double x, double y) {
        this.targetX = x;
        this.targetY = y;
        this.clampTarget();
    }

    public void set(double x, double y) {
        this.x = this.targetX = x;
        this.y = this.targetY = y;
        this.clampTarget();
        this.clampPosition();
    }

    public void setMinimum(double minX, double minY) {
        this.minX = minX;
        this.minY = minY;
    }

    public void setMaximum(double maxX, double maxY) {
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void setBounds(double minX, double minY, double maxX, double maxY) {
        this.setMinimum(minX, minY);
        this.setMaximum(maxX, maxY);
    }

    public void setRotation(double degrees) {
        this.rotation = Math.toRadians(degrees);
    }

    public void setRotationPivot(double pivotX, double pivotY) {
        this.pivotX = pivotX;
        this.pivotY = pivotY;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setScaleCenterPoint(double centerX, double centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public void setSmoothness(float smoothness) {
        this.smoothness = smoothness;
    }

    public double getX() {
        return this.x + this.xOffset;
    }

    public double getY() {
        return this.y + this.yOffset;
    }

    public double getTargetX() {
        return this.targetX;
    }

    public double getTargetY() {
        return this.targetY;
    }

    public float getSmoothness() {
        return this.smoothness;
    }

    public double getMinimumX() {
        return this.minX;
    }

    public double getMinimumY() {
        return this.minY;
    }

    public double getMaximumX() {
        return this.maxX;
    }

    public double getMaximumY() {
        return this.maxY;
    }

    public double getRotation() {
        return this.rotation + this.rotationOffset;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isShaking() {
        return this.shaker.shaking;
    }

    private final class Shaker
    implements IUpdatable {
        private boolean shaking;
        private double xIntensity;
        private double yIntensity;
        private double rotationIntensity;
        private double initialXIntensity;
        private double initialYIntensity;
        private double initialRotationIntensity;
        private float duration;

        @Override
        public void update(double delta) {
            if (!this.shaking) {
                return;
            }
            Camera.this.xOffset = Math.random() * this.xIntensity * 2.0 - this.xIntensity;
            Camera.this.yOffset = Math.random() * this.yIntensity * 2.0 - this.yIntensity;
            Camera.this.rotationOffset = Math.random() * this.rotationIntensity * 2.0 - this.rotationIntensity;
            if (this.duration > 0.0f) {
                this.xIntensity -= this.initialXIntensity / (double)this.duration * delta;
                this.yIntensity -= this.initialYIntensity / (double)this.duration * delta;
                this.rotationIntensity -= this.initialRotationIntensity / (double)this.duration * delta;
            }
        }

        public void shake(double xIntensity, double yIntensity, double rotationIntensity, float duration) {
            this.xIntensity = this.initialXIntensity = xIntensity;
            this.yIntensity = this.initialYIntensity = yIntensity;
            this.rotationIntensity = this.initialRotationIntensity = rotationIntensity;
            this.duration = duration;
            this.shaking = true;
        }

        public void stop() {
            this.shaking = false;
        }
    }
}

