/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.fx;

import de.sogomn.engine.IDrawable;
import de.sogomn.engine.IUpdatable;
import de.sogomn.engine.fx.Animation;
import de.sogomn.engine.util.ImageUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class Background
implements IUpdatable,
IDrawable {
    private int width;
    private int height;
    private double x;
    private double y;
    private double horizontalSpeed;
    private double verticalSpeed;
    private BufferedImage image;
    private Animation animation;

    public Background(BufferedImage image, int width, int height) {
        this.width = width;
        this.height = height;
        this.image = ImageUtils.scaleImage(image, width, height);
    }

    public Background(BufferedImage image) {
        this(image, image.getWidth(), image.getHeight());
    }

    public Background(String path, int width, int height) {
        this(ImageUtils.loadImage(path), width, height);
    }

    public Background(String path) {
        this(ImageUtils.loadImage(path));
    }

    public Background(Animation animation) {
        this(animation.getImage());
        this.animation = animation;
    }

    @Override
    public void update(double delta) {
        if (this.animation != null) {
            this.animation.update(delta);
            this.image = this.animation.getImage();
        }
        this.x += this.horizontalSpeed * delta;
        this.y += this.verticalSpeed * delta;
        this.x %= (double)this.width;
        this.y %= (double)this.height;
    }

    @Override
    public void draw(Graphics2D g) {
        int offsetX = (int)(this.x - (double)this.width * Math.signum(this.x));
        int offsetY = (int)(this.y - (double)this.height * Math.signum(this.y));
        g.drawImage((Image)this.image, (int)this.x, (int)this.y, null);
        if (offsetX != 0 && offsetY != 0) {
            g.drawImage((Image)this.image, offsetX, (int)this.y, null);
            g.drawImage((Image)this.image, (int)this.x, offsetY, null);
            g.drawImage((Image)this.image, offsetX, offsetY, null);
        } else if (offsetX != 0) {
            g.drawImage((Image)this.image, offsetX, (int)this.y, null);
        } else if (offsetY != 0) {
            g.drawImage((Image)this.image, (int)this.x, offsetY, null);
        }
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setHorizontalSpeed(double horizontalSpeed) {
        this.horizontalSpeed = horizontalSpeed;
    }

    public void setVerticalSpeed(double verticalSpeed) {
        this.verticalSpeed = verticalSpeed;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getHorizontalSpeed() {
        return this.horizontalSpeed;
    }

    public double getVerticalSpeed() {
        return this.verticalSpeed;
    }
}

