/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.fx;

import de.sogomn.engine.IUpdatable;
import de.sogomn.engine.fx.IAnimationListener;
import de.sogomn.engine.fx.SpriteSheet;
import de.sogomn.engine.util.AbstractListenerContainer;
import java.awt.image.BufferedImage;

public final class Animation
extends AbstractListenerContainer<IAnimationListener>
implements IUpdatable {
    private BufferedImage[] images;
    private int currentIndex;
    private double timer;
    private float interval;
    private int maxLoops;
    private int currentLoop;
    public static final int INFINITE = -1;

    public Animation(float interval, BufferedImage ... images) {
        this.interval = interval;
        this.images = images;
        this.maxLoops = -1;
    }

    public Animation(float interval, SpriteSheet spriteSheet) {
        this(interval, spriteSheet.getSprites());
    }

    @Override
    public void update(double delta) {
        if (!this.isLooping()) {
            return;
        }
        this.timer += delta;
        if (this.timer >= (double)this.interval) {
            this.timer = 0.0;
            this.nextFrame();
        }
    }

    public void reset() {
        this.timer = 0.0;
        this.currentIndex = 0;
        this.currentLoop = 0;
    }

    public void nextFrame() {
        ++this.currentIndex;
        if (this.currentIndex > this.images.length - 1) {
            this.currentIndex = 0;
            ++this.currentLoop;
            this.notifyListeners(listener -> listener.looped(this));
        }
    }

    public void setInterval(float interval) {
        this.interval = interval;
    }

    public void setMaxLoops(int maxLoops) {
        this.maxLoops = maxLoops;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public float getInterval() {
        return this.interval;
    }

    public BufferedImage getImage() {
        return this.images[this.currentIndex];
    }

    public BufferedImage getImage(int index) {
        if (index < 0 || index > this.length() - 1) {
            return null;
        }
        return this.images[index];
    }

    public int getCurrentLoop() {
        return this.currentLoop;
    }

    public int length() {
        return this.images.length;
    }

    public boolean isLooping() {
        boolean looping = this.maxLoops == -1 || this.currentLoop < this.maxLoops;
        return looping;
    }
}

