/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.debug;

import de.sogomn.engine.Clock;
import java.io.PrintStream;
import java.util.LinkedList;

public final class Profiler {
    private PrintStream out;
    private Clock clock;
    private LinkedList<Section> sections;
    private boolean profiling;
    private String lastName;

    public Profiler(PrintStream out) {
        this.out = out;
        this.clock = new Clock();
        this.sections = new LinkedList();
    }

    public Profiler() {
        this(System.out);
    }

    private void newSection() {
        double elapsed = this.clock.update();
        Section section = new Section(this.lastName, elapsed);
        this.sections.add(section);
    }

    private void printSections() {
        double totalTime = this.clock.elapsed();
        for (Section section : this.sections) {
            this.out.println(section);
        }
        this.out.println("Total - " + totalTime);
    }

    public void start(String name) {
        if (!this.profiling) {
            this.profiling = true;
            this.clock.reset();
        } else {
            this.newSection();
        }
        this.lastName = name;
    }

    public void end() {
        if (!this.profiling) {
            return;
        }
        this.newSection();
        this.printSections();
        this.profiling = false;
        this.lastName = null;
        this.clock.reset();
        this.sections.clear();
    }

    private final class Section {
        private final String name;
        private final double time;

        public Section(String name, double time) {
            this.name = name;
            this.time = time;
        }

        public String toString() {
            return String.valueOf(this.name) + " - " + this.time;
        }
    }
}

