/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine;

import de.sogomn.engine.IDrawable;
import de.sogomn.engine.IKeyboardListener;
import de.sogomn.engine.IMouseListener;
import de.sogomn.engine.Keyboard;
import de.sogomn.engine.Mouse;
import de.sogomn.engine.util.AbstractListenerContainer;
import de.sogomn.engine.util.ImageUtils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;

public final class Screen
extends AbstractListenerContainer<IDrawable> {
    private JFrame frame;
    private Canvas canvas;
    private Mouse mouse;
    private Keyboard keyboard;
    private VolatileImage screenImage;
    private boolean open;
    private int initialWidth;
    private int initialHeight;
    private int canvasWidth;
    private int canvasHeight;
    private int renderWidth;
    private int renderHeight;
    private int renderX;
    private int renderY;
    private ResizeBehavior resizeBehavior;
    private static final int BUFFER_COUNT = 2;
    private static final String NO_TITLE = "";
    public static final Cursor NO_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(1, 1, 2), new Point(0, 0), "No cursor");

    public Screen(int width, int height, String title) {
        this.frame = new JFrame(title);
        this.canvas = new Canvas();
        this.mouse = new Mouse();
        this.keyboard = new Keyboard();
        WindowAdapter closingAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                Screen.this.close();
            }
        };
        ComponentAdapter resizeAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent c) {
                Screen.this.calculateViewport();
            }
        };
        this.open = true;
        this.canvasWidth = this.renderWidth = width;
        this.initialWidth = this.renderWidth;
        this.canvasHeight = this.renderHeight = height;
        this.initialHeight = this.renderHeight;
        this.resizeBehavior = ResizeBehavior.STRETCH;
        this.canvas.setPreferredSize(new Dimension(width, height));
        this.canvas.setIgnoreRepaint(true);
        this.canvas.addMouseListener(this.mouse);
        this.canvas.addMouseMotionListener(this.mouse);
        this.canvas.addMouseWheelListener(this.mouse);
        this.canvas.addKeyListener(this.keyboard);
        this.frame.addMouseListener(this.mouse);
        this.frame.addMouseMotionListener(this.mouse);
        this.frame.addMouseWheelListener(this.mouse);
        this.frame.addKeyListener(this.keyboard);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setIgnoreRepaint(true);
        this.frame.enableInputMethods(false);
        this.frame.addWindowListener(closingAdapter);
        this.frame.addComponentListener(resizeAdapter);
        this.frame.add((Component)this.canvas, "Center");
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
    }

    public Screen(int width, int height) {
        this(width, height, NO_TITLE);
    }

    private void calculateViewport() {
        this.canvasWidth = this.canvas.getWidth();
        this.canvasHeight = this.canvas.getHeight();
        if (this.resizeBehavior == ResizeBehavior.STRETCH) {
            this.stretchContentSize();
        } else if (this.resizeBehavior == ResizeBehavior.KEEP_ASPECT_RATIO) {
            this.fitContentSize();
        } else if (this.resizeBehavior == ResizeBehavior.KEEP_SIZE) {
            this.keepContentSize();
        } else if (this.resizeBehavior == ResizeBehavior.DO_NOTHING) {
            return;
        }
        this.renderX = this.canvasWidth / 2 - this.renderWidth / 2;
        this.renderY = this.canvasHeight / 2 - this.renderHeight / 2;
        float scaleX = (float)this.renderWidth / (float)this.initialWidth;
        float scaleY = (float)this.renderHeight / (float)this.initialHeight;
        this.mouse.setScale(scaleX, scaleY);
        this.mouse.setOffset(this.renderX, this.renderY);
    }

    private void stretchContentSize() {
        this.renderWidth = this.canvasWidth;
        this.renderHeight = this.canvasHeight;
    }

    private void fitContentSize() {
        float ratioX = (float)this.canvasWidth / (float)this.initialWidth;
        float ratioY = (float)this.canvasHeight / (float)this.initialHeight;
        if (ratioX < ratioY) {
            this.renderWidth = (int)((float)this.initialWidth * ratioX);
            this.renderHeight = (int)((float)this.initialHeight * ratioX);
        } else {
            this.renderWidth = (int)((float)this.initialWidth * ratioY);
            this.renderHeight = (int)((float)this.initialHeight * ratioY);
        }
    }

    private void keepContentSize() {
        this.renderWidth = this.initialWidth;
        this.renderHeight = this.initialHeight;
    }

    private int validateImage(VolatileImage image) {
        GraphicsConfiguration graphicsConfiguration = this.canvas.getGraphicsConfiguration();
        int returnCode = image.validate(graphicsConfiguration);
        return returnCode;
    }

    private VolatileImage createImage() {
        VolatileImage image = this.canvas.createVolatileImage(this.initialWidth, this.initialHeight);
        return image;
    }

    private void drawOffscreen() {
        do {
            int returnCode;
            if ((returnCode = this.validateImage(this.screenImage)) == 2) {
                this.screenImage = this.createImage();
            }
            Graphics2D g = this.screenImage.createGraphics();
            ImageUtils.applyLowGraphics(g);
            g.clearRect(0, 0, this.initialWidth, this.initialHeight);
            this.notifyListeners(drawable -> drawable.draw(g));
            g.dispose();
        } while (this.screenImage.contentsLost());
    }

    private void drawToScreen() {
        BufferStrategy bufferStrategy = this.canvas.getBufferStrategy();
        do {
            int returnCode;
            if ((returnCode = this.validateImage(this.screenImage)) == 1) {
                this.drawOffscreen();
            } else if (returnCode == 2) {
                this.screenImage = this.createImage();
                this.drawOffscreen();
            }
            Graphics2D canvasGraphics = (Graphics2D)bufferStrategy.getDrawGraphics();
            ImageUtils.applyLowGraphics(canvasGraphics);
            canvasGraphics.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
            canvasGraphics.drawImage(this.screenImage, this.renderX, this.renderY, this.renderWidth, this.renderHeight, null);
            canvasGraphics.dispose();
        } while (bufferStrategy.contentsLost());
        bufferStrategy.show();
    }

    public void redraw() {
        if (!this.isOpen() || !this.isVisible()) {
            return;
        }
        this.drawOffscreen();
        this.drawToScreen();
    }

    public void show() {
        if (!this.isOpen() || this.isVisible()) {
            return;
        }
        this.frame.setVisible(true);
        this.screenImage = this.createImage();
        this.canvas.createBufferStrategy(2);
        this.canvas.requestFocus();
        this.calculateViewport();
        this.redraw();
    }

    public void hide() {
        if (!this.isOpen() || !this.isVisible()) {
            return;
        }
        this.frame.setVisible(false);
    }

    public void close() {
        if (!this.isOpen() || !this.isVisible()) {
            return;
        }
        this.setFullScreen(false);
        this.frame.setVisible(false);
        this.frame.dispose();
        this.open = false;
    }

    public void addMouseListener(IMouseListener listener) {
        this.mouse.addListener(listener);
    }

    public void removeMouseListener(IMouseListener listener) {
        this.mouse.removeListener(listener);
    }

    public void removeAllMouseListeners() {
        this.mouse.removeAllListeners();
    }

    public void addKeyboardListener(IKeyboardListener listener) {
        this.keyboard.addListener(listener);
    }

    public void removeKeyboardListener(IKeyboardListener listener) {
        this.keyboard.removeListener(listener);
    }

    public void removeAllKeyboardListeners() {
        this.keyboard.removeAllListeners();
    }

    public void addWindowListener(WindowListener listener) {
        this.frame.addWindowListener(listener);
    }

    public void removeWindowListener(WindowListener listener) {
        this.frame.removeWindowListener(listener);
    }

    public void setFullScreen(boolean fullScreen) {
        if (!this.isVisible() || !this.isOpen()) {
            return;
        }
        GraphicsDevice display = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        boolean fullScreenAllowed = display.isFullScreenSupported();
        if (fullScreen && fullScreenAllowed) {
            display.setFullScreenWindow(this.frame);
        } else {
            display.setFullScreenWindow(null);
        }
    }

    public void setResizable(boolean resizable) {
        this.frame.setResizable(resizable);
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public void setResizeBehavior(ResizeBehavior resizeBehavior) {
        this.resizeBehavior = resizeBehavior;
    }

    public void setIcons(BufferedImage ... images) {
        List<BufferedImage> imageList = Arrays.asList(images);
        this.frame.setIconImages(imageList);
    }

    public void setSize(int width, int height) {
        boolean visible = this.isVisible();
        Dimension size = new Dimension(width, height);
        this.frame.setVisible(false);
        this.canvas.setPreferredSize(size);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        if (visible) {
            this.show();
        }
    }

    public void setLocation(int x, int y) {
        this.frame.setLocation(x, y);
    }

    public void setCursor(Cursor cursor) {
        this.frame.setCursor(cursor);
    }

    public void setBackgroundColor(Color color) {
        this.canvas.setBackground(color);
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public boolean isResizable() {
        return this.frame.isResizable();
    }

    public boolean isFullScreen() {
        GraphicsDevice display = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Window window = display.getFullScreenWindow();
        boolean fullScreen = window != null && window == this.frame;
        return fullScreen;
    }

    public boolean isFocused() {
        return this.frame.isFocused();
    }

    public int getInitialWidth() {
        return this.initialWidth;
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public int getWidth() {
        return this.canvasWidth;
    }

    public int getHeight() {
        return this.canvasHeight;
    }

    public int getRenderWidth() {
        return this.renderWidth;
    }

    public int getRenderHeight() {
        return this.renderHeight;
    }

    public String getTitle() {
        return this.frame.getTitle();
    }

    public ResizeBehavior getResizeBehavior() {
        return this.resizeBehavior;
    }

    public static enum ResizeBehavior {
        STRETCH,
        KEEP_ASPECT_RATIO,
        KEEP_SIZE,
        DO_NOTHING;

    }
}

